/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.config.CoreClientConfig;
import cofh.lib.api.item.ICoFHItem;
import cofh.lib.util.Constants;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;

public class ItemCoFH
extends Item
implements ICoFHItem {
    protected int burnTime = -1;
    protected int enchantability;
    protected Supplier<CreativeModeTab> displayGroup;
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected String modId = "";

    public ItemCoFH(Item.Properties builder) {
        super(builder);
    }

    public ItemCoFH setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ItemCoFH setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ArrayList<Component> additionalTooltips = new ArrayList<Component>();
        this.tooltipDelegate(stack, worldIn, additionalTooltips, flagIn);
        if (SecurityHelper.isItemClaimable(stack)) {
            tooltip.add((Component)StringHelper.getTextComponent("info.cofh.claimable").m_130940_(ChatFormatting.GREEN).m_130940_(ChatFormatting.ITALIC));
        }
        if (!additionalTooltips.isEmpty()) {
            if (Screen.m_96638_() || CoreClientConfig.alwaysShowDetails.get().booleanValue()) {
                tooltip.addAll(additionalTooltips);
            } else if (CoreClientConfig.holdShiftForDetails.get().booleanValue()) {
                tooltip.add((Component)StringHelper.getTextComponent("info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.enchantability;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return this.burnTime;
    }

    protected static Set<ToolAction> toolActions(ToolAction ... actions) {
        return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    @Override
    public ItemCoFH setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    @Override
    public ItemCoFH setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public ItemCoFH setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }
}

